/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;

public class Scan {
    private byte[] rledata;
    private List<BlockState> materialPalette = new ArrayList<BlockState>();
    private BlockPos dataDim;
    private BlockPos dataOffset = new BlockPos(0, 0, 0);
    private int dirtyCounter = 0;
    public int dirtyRequestTimeout = 0;
    public static final byte[] EMPTY = new byte[0];

    public byte[] getRledata() {
        if (this.rledata == null) {
            return EMPTY;
        }
        return this.rledata;
    }

    public byte[] getDataInt() {
        return this.rledata;
    }

    public void setData(byte[] data, List<BlockState> materialPalette, BlockPos dim, BlockPos offset) {
        this.rledata = data;
        this.materialPalette = materialPalette;
        this.dataDim = dim;
        this.dataOffset = offset;
        ++this.dirtyCounter;
    }

    public void setDirtyCounter(int dirtyCounter) {
        this.dirtyCounter = dirtyCounter;
    }

    public int getDirtyCounter() {
        return this.dirtyCounter;
    }

    public List<BlockState> getMaterialPalette() {
        return this.materialPalette;
    }

    public BlockPos getDataDim() {
        return this.dataDim;
    }

    public BlockPos getDataOffset() {
        return this.dataOffset;
    }

    public void writeToNBT(CompoundTag tagCompound) {
        tagCompound.m_128405_("dirty", this.dirtyCounter);
    }

    public void writeToNBTExternal(CompoundTag tagCompound) {
        tagCompound.m_128382_("data", this.rledata == null ? new byte[]{} : this.rledata);
        ListTag pal = new ListTag();
        for (BlockState state : this.materialPalette) {
            CompoundTag tc = NbtUtils.m_129202_((BlockState)state);
            pal.add((Object)tc);
        }
        tagCompound.m_128365_("scanpal", (Tag)pal);
        if (this.dataDim != null) {
            tagCompound.m_128405_("scandimx", this.dataDim.m_123341_());
            tagCompound.m_128405_("scandimy", this.dataDim.m_123342_());
            tagCompound.m_128405_("scandimz", this.dataDim.m_123343_());
        }
        if (this.dataOffset != null) {
            tagCompound.m_128405_("scanoffx", this.dataOffset.m_123341_());
            tagCompound.m_128405_("scanoffy", this.dataOffset.m_123342_());
            tagCompound.m_128405_("scanoffz", this.dataOffset.m_123343_());
        }
    }

    public void readFromNBT(CompoundTag tagCompound) {
        this.dirtyCounter = tagCompound.m_128451_("dirty");
    }

    public void readFromNBTExternal(CompoundTag tagCompound) {
        ListTag list = tagCompound.m_128437_("scanpal", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tc = list.m_128728_(i);
            BlockState state = NbtUtils.m_129241_((CompoundTag)tc);
            this.materialPalette.add(state);
        }
        this.rledata = tagCompound.m_128463_("data");
        this.dataDim = new BlockPos(tagCompound.m_128451_("scandimx"), tagCompound.m_128451_("scandimy"), tagCompound.m_128451_("scandimz"));
        this.dataOffset = new BlockPos(tagCompound.m_128451_("scanoffx"), tagCompound.m_128451_("scanoffy"), tagCompound.m_128451_("scanoffz"));
    }
}

